<?php
/**
 * XOOPS Publisher Custom Smarty Plugin - v2.0
 * 
 * Bu plugin Publisher modülündeki içerikleri tema içinde görüntülemenizi sağlar
 * 
 * Kullanım:
 * {custom category="2" template="topgames" available="main" from="0" limit="20" cache="no" order="date"}
 * 
 * Debug için: {custom limit="5" debug="1"}
 * Eren Yumak aka B.Heyula! tarafından kodlanmıştır.
 */

function smarty_function_custom($params, $smarty)
{
    global $xoopsDB, $xoopsConfig, $xoopsModule, $xoopsUser;
    
    // Publisher modülünün yüklü olup olmadığını kontrol et
    if (!is_dir(XOOPS_ROOT_PATH . '/modules/publisher')) {
        return "<!-- Publisher modülü bulunamadı -->";
    }
    
    // Parametreleri al
    $category = isset($params['category']) ? intval($params['category']) : 0;
    $template = isset($params['template']) ? trim($params['template']) : 'publisher_custom';
    $available = isset($params['available']) ? trim($params['available']) : '';
    $from = isset($params['from']) ? intval($params['from']) : 0;
    $limit = isset($params['limit']) ? intval($params['limit']) : 10;
    $cache = isset($params['cache']) ? strtolower(trim($params['cache'])) : 'no'; // Varsayılan no yaptık
    $order = isset($params['order']) ? strtolower(trim($params['order'])) : 'date';
    $sort = isset($params['sort']) ? strtoupper(trim($params['sort'])) : 'DESC';
    $status = isset($params['status']) ? intval($params['status']) : 1;
    $debug = isset($params['debug']) ? true : false;
    
    // Tablo prefix'ini al
    $prefix = $xoopsDB->prefix();
    
    // Debug bilgileri
    $debug_info = '';
    if ($debug) {
        $debug_info .= "<!-- DEBUG MODE AKTIF -->\n";
        $debug_info .= "<!-- Parametreler: category=$category, limit=$limit, order=$order, status=$status -->\n";
        $debug_info .= "<!-- Tablo prefix: $prefix -->\n";
    }
    
    // Tablo isimleri
    $items_table = $prefix . "_publisher_items";
    $text_table = $prefix . "_publisher_items_text";
    
    if ($debug) {
        $debug_info .= "<!-- Items tablo: $items_table -->\n";
        $debug_info .= "<!-- Text tablo: $text_table -->\n";
    }
    
    // Sıralama alanını belirle
    $orderby = 'datesub';
    switch ($order) {
        case 'title': $orderby = 'title'; break;
        case 'counter': $orderby = 'counter'; break;
        case 'weight': $orderby = 'weight'; break;
        case 'rating': $orderby = 'rating'; break;
        case 'random': $orderby = 'RAND()'; break; // Rastgele sıralama
        case 'date':
        default: $orderby = 'datesub'; break;
    }
    
    // SQL sorgusu oluştur
    $sql = "SELECT * FROM $items_table WHERE status = $status";
    
    // Kategori filtresi
    if ($category > 0) {
        $sql .= " AND categoryid = $category";
    }
    
    // Available filtresi
    if (!empty($available)) {
        switch (strtolower($available)) {
            case 'main':
                $sql .= " AND item_tag LIKE '%main%'";
                break;
            case 'spotlight':
                $sql .= " AND item_tag LIKE '%spotlight%'";
                break;
        }
    }
    
    // Sıralama ve limit
    $sql .= " ORDER BY $orderby $sort LIMIT $from, $limit";
    
    if ($debug) {
        $debug_info .= "<!-- SQL: " . htmlspecialchars($sql) . " -->\n";
    }
    
    // Sorguyu çalıştır
    $result = $xoopsDB->query($sql);
    
    if (!$result) {
        return $debug_info . '<div class="publisher-error" style="color:red;padding:10px;border:1px solid red;">
                SQL hatası: ' . $xoopsDB->error() . '</div>';
    }
    
    $row_count = $xoopsDB->getRowsNum($result);
    
    if ($debug) {
        $debug_info .= "<!-- Bulunan kayıt sayısı: $row_count -->\n";
    }
    
    $items = array();
    
    if ($row_count > 0) {
        while ($row = $xoopsDB->fetchArray($result)) {
            $item = array();
            $item['itemid'] = $row['itemid'];
            $item['title'] = htmlspecialchars($row['title'], ENT_QUOTES);
            $item['subtitle'] = isset($row['subtitle']) ? htmlspecialchars($row['subtitle'], ENT_QUOTES) : '';
            $item['categoryid'] = $row['categoryid'];
            $item['uid'] = isset($row['uid']) ? $row['uid'] : 0;
            $item['datesub'] = isset($row['datesub']) ? $row['datesub'] : time();
            $item['counter'] = isset($row['counter']) ? $row['counter'] : 0;
            $item['rating'] = isset($row['rating']) ? $row['rating'] : 0;
            $item['votes'] = isset($row['votes']) ? $row['votes'] : 0;
            $item['weight'] = isset($row['weight']) ? $row['weight'] : 0;
            
            // Summary ve body - önce ana tablodan
            $item['summary'] = isset($row['summary']) ? $row['summary'] : '';
            $item['body'] = isset($row['body']) ? $row['body'] : '';
            
            // Eğer text tablosu varsa oradan al
            $text_check = $xoopsDB->query("SHOW TABLES LIKE '$text_table'");
            if ($text_check && $xoopsDB->getRowsNum($text_check) > 0) {
                $text_sql = "SELECT summary, body FROM $text_table WHERE itemid = " . $row['itemid'];
                $text_result = $xoopsDB->query($text_sql);
                if ($text_result && $xoopsDB->getRowsNum($text_result) > 0) {
                    $text_row = $xoopsDB->fetchArray($text_result);
                    if (!empty($text_row['summary'])) $item['summary'] = $text_row['summary'];
                    if (!empty($text_row['body'])) $item['body'] = $text_row['body'];
                }
            }
            
            // Resim - farklı alan adlarını kontrol et
            $image_id = '';
            $possible_image_fields = array('image', 'item_image', 'images', 'doimage');
            foreach ($possible_image_fields as $field) {
                if (isset($row[$field]) && !empty($row[$field])) {
                    $image_id = $row[$field];
                    break;
                }
            }
            
            if (!empty($image_id)) {
                // Resim ID'si varsa, xaf9_image tablosundan gerçek dosya adını al
                $image_table = $prefix . "_image";
                $image_sql = "SELECT image_name FROM $image_table WHERE image_id = " . intval($image_id);
                $image_result = $xoopsDB->query($image_sql);
                
                $image_filename = '';
                if ($image_result && $xoopsDB->getRowsNum($image_result) > 0) {
                    $image_row = $xoopsDB->fetchArray($image_result);
                    $image_filename = $image_row['image_name'];
                }
                
                if ($debug) {
                    $debug_info .= "<!-- Resim ID: $image_id, Dosya adı: $image_filename -->\n";
                }
                
                if (!empty($image_filename)) {
                    // Resim dosyası bulundu
                    // Eğer dosya adı zaten "images/" ile başlıyorsa, onu kaldır
                    if (strpos($image_filename, 'images/') === 0) {
                        $image_filename = substr($image_filename, 7); // "images/" kısmını çıkar (7 karakter)
                    }
                    
                    $item['image'] = XOOPS_URL . '/uploads/images/' . $image_filename;
                    
                    // Thumb kontrolü
                    $thumb_path = XOOPS_ROOT_PATH . '/uploads/images/thumbs/' . $image_filename;
                    if (file_exists($thumb_path)) {
                        $item['thumb'] = XOOPS_URL . '/uploads/images/thumbs/' . $image_filename;
                    } else {
                        // Thumb yoksa ana resmi kullan
                        $item['thumb'] = $item['image'];
                    }
                    
                    if ($debug) {
                        $debug_info .= "<!-- Resim URL: " . $item['image'] . " -->\n";
                        $debug_info .= "<!-- Thumb URL: " . $item['thumb'] . " -->\n";
                    }
                } else {
                    // Resim dosyası bulunamadı
                    $item['image'] = '';
                    $item['thumb'] = '';
                    
                    if ($debug) {
                        $debug_info .= "<!-- Resim ID $image_id için dosya bulunamadı -->\n";
                    }
                }
            } else {
                // Resim ID'si yok
                $item['image'] = '';
                $item['thumb'] = '';
            }
            
            // Linkler
            $item['link'] = XOOPS_URL . '/modules/publisher/item.php?itemid=' . $row['itemid'];
            $item['category_link'] = XOOPS_URL . '/modules/publisher/category.php?categoryid=' . $row['categoryid'];
            
            // Tarih formatla
            $item['date'] = formatTimestamp($item['datesub'], 's');
            $item['date_short'] = formatTimestamp($item['datesub'], 'm');
            
            // Yazar bilgisi
            if ($item['uid'] > 0) {
                $member_handler = xoops_getHandler('member');
                $author = $member_handler->getUser($item['uid']);
                if (is_object($author)) {
                    $item['author_name'] = $author->getVar('uname');
                    $item['author_link'] = XOOPS_URL . '/userinfo.php?uid=' . $item['uid'];
                } else {
                    $item['author_name'] = $xoopsConfig['anonymous'];
                    $item['author_link'] = '';
                }
            } else {
                $item['author_name'] = $xoopsConfig['anonymous'];
                $item['author_link'] = '';
            }
            
            // Rating yüzdesi
            $item['rating_percent'] = ($item['votes'] > 0) ? ($item['rating'] / 5) * 100 : 0;
            
            $items[] = $item;
        }
    }
    
    if ($debug) {
        $debug_info .= "<!-- İşlenen item sayısı: " . count($items) . " -->\n";
        if (count($items) > 0) {
            $debug_info .= "<!-- İlk item: " . htmlspecialchars(print_r($items[0], true)) . " -->\n";
        }
    }
    
    // Template'e değişkenleri ata
    $smarty->assign('publisher_items', $items);
    $smarty->assign('publisher_count', count($items));
    
    // Template dosyasını bul
    $theme = $xoopsConfig['theme_set'];
    $template_paths = array(
        XOOPS_ROOT_PATH . '/themes/' . $theme . '/templates/' . $template . '.tpl',
        XOOPS_ROOT_PATH . '/modules/publisher/templates/blocks/' . $template . '.tpl',
        XOOPS_ROOT_PATH . '/themes/' . $theme . '/templates/publisher_custom.tpl',
    );
    
    $template_path = '';
    foreach ($template_paths as $path) {
        if (file_exists($path)) {
            $template_path = $path;
            break;
        }
    }
    
    if ($debug) {
        $debug_info .= "<!-- Template aranan yerler:\n";
        foreach ($template_paths as $p) {
            $debug_info .= "  " . $p . " - " . (file_exists($p) ? "BULUNDU" : "yok") . "\n";
        }
        $debug_info .= "-->\n";
        $debug_info .= "<!-- Kullanılan template: " . $template_path . " -->\n";
    }
    
    // Template render
    if (!empty($template_path)) {
        // Tam yolu kullan, template_dir'i değiştirme
        $output = $smarty->fetch('file:' . $template_path);
    } else {
        $output = '<div class="publisher-error" style="color:orange;padding:10px;border:1px solid orange;">
                   Template dosyası bulunamadı: ' . $template . '.tpl<br>
                   Aranan yerler:<br>' . implode('<br>', $template_paths) . '</div>';
    }
    
    return $debug_info . $output;
}
